function EFFECT:Init(data)
	-- [[
	local dynlight = DynamicLight(0)
	dynlight.Pos = data:GetOrigin()
	dynlight.Size = 400
	dynlight.Decay = 3000
	dynlight.R = 255
	dynlight.G = 255
	dynlight.B = 155
	dynlight.DieTime = CurTime() + 1.1
	--]]

	self.Time = CurTime() + 0.3
	self.Sprite = Material("sprites/fthrow" ..math.random(1, 3))
	self.Size = 10
	self.Normal = data:GetNormal()
end
 
function EFFECT:Think()
	local ElapsedTime = self.Time - CurTime()
	if ElapsedTime <= 0 then return false end
	self.Size = self.Size + ElapsedTime * 75
	self:SetPos(self:GetPos() + self.Normal * 50)
	return true
end

 
function EFFECT:Render()
	local ElapsedTime = self.Time - CurTime()
	local Pos = self.Entity:GetPos() + (EyePos() - self.Entity:GetPos()):GetNormal()
	self.Sprite:SetFloat("$alpha", math.sin((ElapsedTime / 0.3) * math.pi / 2))
	--self.Sprite:SetInt("$frame", math.Clamp(math.floor(30 - (self.time - CurTime()) * 30), 0, 15))
	render.SetMaterial(self.Sprite)
	render.DrawSprite(Pos, self.Size, self.Size)
end